#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/bbh/header.h"
extern u8 _bbh_segment_ESegmentRomStart[];
extern u8 _bbh_segment_ESegmentRomEnd[];

const LevelScript level_bbh_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _bbh_segment_ESegmentRomStart, _bbh_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _bbh_skybox_mio0SegmentRomStart, _bbh_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group9_mio0SegmentRomStart, _group9_mio0SegmentRomEnd),
LOAD_RAW(12, _group9_geoSegmentRomStart, _group9_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(29,  haunted_door_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_10),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_bbh_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_bbh_1_[] = {
AREA(1, Geo_bbh_1_0x14c5940),
TERRAIN(col_bbh_1_0xe096cd0),
SET_BACKGROUND_MUSIC(0, 35),
TERRAIN_TYPE(1),
JUMP_LINK(local_objects_bbh_1_),
JUMP_LINK(local_warps_bbh_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_bbh_1_[] = {
OBJECT_WITH_ACTS(0, -7200, 1024, -550, 0, 90, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, -1483, 631, -2109, 0, 90, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 3620, 1375, -465, 0, 0, 0, 0x3000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(0, 278, 1214, -574, 0, 0, 0, 0x2080000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(0, 1502, 1818, 2550, 0, 0, 0, 0x4080000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 1547, -677, 1080, 0, 0, 0, 0x5010000,  bhvMrI, 31),
OBJECT_WITH_ACTS(215, -3790, 396, -480, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3159, 660, 1806, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3790, 204, -2208, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 690, 198, -998, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3106, 970, -1740, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3790, 1145, -1587, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 610, 1440, 1191, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2790, 273, -1196, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, 16, 1119, -297, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -239, 1119, -251, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 289, 1119, 339, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 84, 1119, 168, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 175, 1119, -30, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(29, -3, 104, -200, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -2848, 104, -200, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 2397, 104, -200, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(31, 3597, 104, -200, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -252, 104, -799, 0, 180, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -1952, 104, -799, 0, 180, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 1248, 104, -799, 0, 180, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -798, 1119, -799, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -2648, 1119, -799, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 1053, 1119, -799, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 2822, 1119, -200, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 2452, 104, -2425, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -3926, 104, -428, 0, 90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -3926, 104, -572, 0, -90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -806, 104, 1172, 0, 90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, -806, 104, 1028, 0, -90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 1794, 104, 1028, 0, -90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(29, 1794, 104, 1172, 0, 90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(137, 3596, -546, 51, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(84, 294, 204, -1812, 0, 0, 0, 0x0,  bhvGhostHuntBoo, 31),
OBJECT_WITH_ACTS(84, 2365, 204, 1800, 0, 0, 0, 0x0,  bhvGhostHuntBoo, 31),
OBJECT_WITH_ACTS(84, -2241, 1219, 1240, 0, 0, 0, 0x0,  bhvGhostHuntBoo, 31),
OBJECT_WITH_ACTS(84, 1989, 1369, -214, 0, 0, 0, 0x0,  bhvGhostHuntBoo, 31),
OBJECT_WITH_ACTS(84, 2447, 204, -2838, 0, 0, 0, 0x0,  bhvGhostHuntBoo, 31),
OBJECT_WITH_ACTS(84, 511, 454, 1110, 0, 0, 0, 0x1000000,  bhvGhostHuntBigBoo, 31),
OBJECT_WITH_ACTS(87, -920, 104, -1198, 0, 0, 0, 0x0,  bhvMadPiano, 31),
OBJECT_WITH_ACTS(129, -1549, 514, -2238, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(0, -2334, 104, -1455, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, -3191, 1119, -62, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, 2766, -702, 1712, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(101, 513, 0, 3501, 0, 33, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, -313, 0, 3096, 0, 332, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, -1174, 0, -3243, 0, 33, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, -280, 0, -3752, 0, 306, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, 4873, 0, -666, 0, 306, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, 4706, 0, 359, 0, 156, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(137, 4808, 256, 0, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 3063, 1119, 1451, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(140, -1812, 204, 1756, 0, 45, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -2067, 354, 1105, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -2620, 354, 1105, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -2339, 354, 1325, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -2339, 354, 874, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(144, -2300, 154, 2200, 0, 180, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(144, -2400, 154, 2200, 0, 180, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(144, -2350, 154, 2200, 0, 180, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(101, -5689, 0, -2768, 0, 136, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, -5688, 0, 2113, 0, 326, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(145, -4050, 304, -800, 0, 90, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(145, -4050, 304, -200, 0, 90, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(137, -3097, 380, -1263, 0, 71, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(86, 2489, -702, 501, 0, 0, 0, 0x0,  bhvHauntedChair, 31),
OBJECT_WITH_ACTS(86, 2896, -702, 652, 0, 0, 0, 0x0,  bhvHauntedChair, 31),
OBJECT_WITH_ACTS(144, 3130, 454, 1430, 0, 90, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(144, 3130, 454, 1720, 0, 90, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(0, 1502, 1818, 2550, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(124, -5344, 0, -115, 0, 270, 0, 0x280000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(132, -1709, 104, -1112, 0, 270, 0, 0x2b0000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, -27, 104, -967, 0, 270, 0, 0x2e0000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, 1450, 104, -986, 0, 270, 0, 0x310000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, -2987, 104, -53, 0, 90, 0, 0x320000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, -154, 104, -41, 0, 90, 0, 0x330000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, 2245, 104, -52, 0, 90, 0, 0x340000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, -2803, 1119, -636, 0, 90, 0, 0x350000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, -953, 1119, -630, 0, 90, 0, 0x360000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, 916, 1119, -647, 0, 90, 0, 0x3e0000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, 2665, 1119, -35, 0, 90, 0, 0x3f0000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(132, 3668, -702, 2226, 0, 180, 0, 0x400000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(124, -1390, 450, -2245, 0, 270, 0, 0x410000,  bhvMessagePanel, 31),
RETURN()
};

const LevelScript local_warps_bbh_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 1, 45, 0),
WARP_NODE(241, 6, 1, 55, 0),
RETURN()
};
